import os
import copy
import json
import pandas as pd
import h5py
import os
import numpy as np
import sys
from main import *
#import direct_request 

filename = "2022.json"



def get_mix_for_latlon(lat, lon, direct=False):
    lcohs, lcoes =  get_point('multiple_inputs', lat, lon, water_session, ernc_session)
    inputs_results = {}
    for input_name in lcohs.keys():
        lcoh = lcohs[input_name][2]
        mixes = lcohs[input_name][1:]
        lcoh_eolo = mixes[1][2]
        lcoh_solar = mixes[-1][2]
        mixes.sort(key=lambda x: x[2])
        best_mix = mixes[0]
        
        inputs_results[input_name] = {"lcoh":lcoh, 
                                      "best_mix":best_mix,
                                      "lcoh_eolo":lcoh_eolo,
                                      "lcoh_solar":lcoh_solar,
                                      "lcoe_eolo": lcoes[input_name]["eolic"],
                                      "lcoe_solar":lcoes[input_name]["solar"]}

    return inputs_results

def calc_h5_from_file_config( out_name="test", small=False, direct=False):
    mask = h5py.File(os.path.join("data","h5", "mask_v2.h5"), 'r')
    inputs_results = get_mix_for_latlon( -22.28, -68.46)
    n_inputs = len(inputs_results.keys())
    
    try:
        ofile = h5py.File(os.path.join("data","h5", out_name + ".h5"), 'a')
        ofile["mask"]
        is_before = True
        print("\n\n LOADED FROM BEFORE!!! \n\n")
    except:
        ofile.close()
        is_before = False
        ofile = h5py.File(os.path.join("data","h5", out_name + ".h5"), 'w')
        ofile.create_dataset("mask", mask["mask"].shape, 'i2')
        ofile["mask"][:] = -1
        ofile.create_dataset("lat",  mask["lat"].shape, 'f8')
        ofile.create_dataset("lon",  mask["lon"].shape, 'f8')
    
        ofile.create_dataset("lcoh",            (n_inputs, *ofile["mask"].shape), 'f8')
        ofile.create_dataset("lcoh_best",       (n_inputs, *ofile["mask"].shape), 'f8')
        ofile.create_dataset("lcoh_eolo",       (n_inputs, *ofile["mask"].shape), 'f8')
        ofile.create_dataset("lcoh_solar",       (n_inputs, *ofile["mask"].shape), 'f8')
        ofile.create_dataset("frac_eolo",          (n_inputs, *ofile["mask"].shape), 'u1')
        ofile.create_dataset("frac_solar",          (n_inputs, *ofile["mask"].shape), 'u1')
        ofile.create_dataset("lcoe_solar",      (n_inputs, *ofile["mask"].shape), 'f8')
        ofile.create_dataset("lcoe_eolo",       (n_inputs, *ofile["mask"].shape), 'f8')
        ofile.create_dataset("inputs_names",    data=list(inputs_results.keys()))
    
        ofile["lat"][:] = mask["lat"][:]
        ofile["lon"][:] = mask["lon"][:]
    # mask["mask"][lon, lat]
    n_lon = mask["lon"].shape[0]
    n_lat = mask["lat"].shape[0]
    if small:
        start_lat = int((49-37) * n_lat / 100)
        end_lat = int((50-37) * n_lat / 100)
    else:
        start_lat = 0
        end_lat = n_lat
    advance_perc = 0
    lcoh = 0
    for i_lon in range(n_lon):
        perc = round((i_lon/n_lon) * 100)
        if ( perc >= advance_perc):
            print("Advanced: ", perc, i_lon, n_lon, lcoh)
            advance_perc += 1
            ofile.close()
            ofile = h5py.File(os.path.join("data","h5", out_name + ".h5"), 'a')
            
            

        for i_lat in range(start_lat, end_lat):
            #if is_before and (ofile["mask"][i_lon, i_lat] == 1 or ofile["mask"][i_lon, i_lat] == 0):
            if is_before and ofile["mask"][i_lon, i_lat] == 1 : #or ofile["mask"][i_lon, i_lat] == 0):
                continue
            ofile["mask"][i_lon, i_lat] = 0
            if mask["mask"][i_lon, i_lat] == 1:
                lat = mask["lat"][i_lat]
                lon = mask["lon"][i_lon]
                try:
                    point_results = get_mix_for_latlon(lat, lon, direct)
                    for i_input, name_config in enumerate(inputs_results.keys()):
                        results = point_results[name_config]
                        lcoh = results["lcoh"]
                        best_mix = results["best_mix"]
                        lcoh_eolo = results["lcoh_eolo"]
                        lcoh_solar = results["lcoh_solar"]
                        lcoe_eolo = results["lcoe_eolo"]
                        lcoe_solar = results["lcoe_solar"]

                        ofile["mask"][i_lon, i_lat] = 1

                        ofile["lcoh"][i_input, i_lon, i_lat] = lcoh[2]
                        ofile["lcoh_eolo"][i_input, i_lon, i_lat] = lcoh_eolo
                        ofile["lcoh_solar"][i_input, i_lon, i_lat] = lcoh_solar
                        ofile["lcoh_best"][i_input, i_lon, i_lat] = best_mix[2]
                        ofile["frac_eolo"][i_input, i_lon, i_lat] = best_mix[0]
                        ofile["frac_solar"][i_input, i_lon, i_lat] = best_mix[1]
                        ofile["lcoe_solar"][i_input, i_lon, i_lat] = lcoe_solar
                        ofile["lcoe_eolo"][i_input, i_lon, i_lat] = lcoe_eolo
                        print(lcoh, " advanced ", perc)
                except:
                    #print(f"Error in lat, lon ({lat}, {lon}) in calck LCOH")
                    print("error in ", lat, lon, " advanced ", perc)

    
    ofile.close()

    return

def to_geotiff(fh5, filename,  var_name):
	fo  = h5py.File( fh5, 'r' )

   
	filename = filename + "_" + var_name + ".tif"
	
	lon0 = fo["lon"][0]
	lat0 = fo["lat"][0]

	dlon = 0.01
	dlat = 0.01

	rasterOrigin=(lon0,lat0)
	pixelWidth  = dlon
	pixelHeight = dlat

	# Factor de planta
	array       = np.squeeze(fo[var_name][:,:])
	array       = np.transpose(array)
	array2raster(filename,rasterOrigin,pixelWidth,pixelHeight,array)
	#publish_geotiff( filename )
    
	return

def to_geotiff_multiple(fh5, prefix,  var_name):
    fo  = h5py.File( fh5, 'r' )


    configs = fo["inputs_names"][:]
    configs = [str(f) for f in configs]


    lon0 = fo["lon"][0]
    lat0 = fo["lat"][0]

    dlon = 0.01
    dlat = 0.01

    rasterOrigin=(lon0,lat0)
    pixelWidth  = dlon
    pixelHeight = dlat

    for i_config, config_name in enumerate(configs):

        filename = prefix + "_" + var_name + "_" + config_name + ".tif"
        filename = str(filename)
        array       = np.squeeze(fo[var_name][i_config, :,:])
        array       = np.transpose(array)
        array2raster(filename,rasterOrigin,pixelWidth,pixelHeight,array)

    return
def array2raster(newRasterfn,rasterOrigin,pixelWidth,pixelHeight,array):

    cols = array.shape[1]
    rows = array.shape[0]
    originX = rasterOrigin[0]
    originY = rasterOrigin[1]

    driver = gdal.GetDriverByName('GTiff')
    outRaster = driver.Create(newRasterfn, cols, rows, 1, gdal.GDT_Float32)
    outRaster.SetGeoTransform((originX, pixelWidth, 0, originY, 0, pixelHeight))
    outband = outRaster.GetRasterBand(1)
    outband.WriteArray(array)
    outRasterSRS = osr.SpatialReference()
    outRasterSRS.ImportFromEPSG(4326)
    outRaster.SetProjection(outRasterSRS.ExportToWkt())
    outband.FlushCache()
    return

def publish_geotiff(work_file, usemask=True, doutm=True):

	path, vname = os.path.split(work_file)

	geogpath   = '../geog/'
	fname = work_file
	fname_ll   = '../geog/geotiff/latlon/%s_ll.tif' % (vname, )
	fname_utm  = '../geog/geotiff/utm/%s_utm.tif' % (vname,) 

	if usemask:
		comm = 'gdalwarp -overwrite -srcnodata -9999 -dstnodata -9999 -crop_to_cutline -cutline %s/masks/CL_Buffer_15km_DDw84.shp %s %s' % (geogpath, fname, fname_ll)
		print(comm)
		os.system(comm);

		if doutm:
			comm = "gdalwarp -overwrite -srcnodata -9999 -dstnodata -9999 -s_srs EPSG:4326 -t_srs '+proj=utm +zone=19 +datum=WGS84 +south' -tr 1000 1000 -r bilinear -crop_to_cutline -cutline %s/masks/CL_Buffer_15km_DDw84.shp %s %s" % (geogpath, fname, fname_utm)
			print(comm)
			os.system(comm);
	else:
		comm = 'gdalwarp -overwrite -srcnodata -9999 -dstnodata -9999 %s %s' % (fname, fname_ll)
		print(comm)
		os.system(comm);

		if doutm:
			comm = "gdalwarp -overwrite -srcnodata -9999 -dstnodata -9999 -s_srs EPSG:4326 -t_srs '+proj=utm +zone=19 +datum=WGS84 +south' -tr 1000 1000 -r bilinear %s %s" % (fname, fname_utm)
			print(comm)
			os.system(comm);


def calc_geotifs_from_h5( out_name ):
    if "LCOE" in out_name:
        to_geotiff_multiple(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "lcoe_eolo")
        to_geotiff_multiple(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "lcoe_solar")
    else:
        to_geotiff(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "mask")
        to_geotiff_multiple(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "lcoh")
        to_geotiff_multiple(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "lcoh_best")
        to_geotiff_multiple(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "frac_1")
        to_geotiff_multiple(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "frac_2")
        to_geotiff_multiple(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "lcoe_eolo")
        to_geotiff_multiple(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "lcoe_solar")
    

if __name__ == "__main__":
    import time 
    start = time.time()
    ernc_session = requests.Session()
    water_session = requests.Session()
    if len(sys.argv)>1:
        op = sys.argv[1]
        if op == "do_h5":
                out_name = sys.argv[2]
                is_small = 'small' in out_name
                print("DOING ", out_name)
                calc_h5_from_file_config( out_name=out_name, small=is_small, direct=False)
                print(" now do with python2 environemtn ' python get_map_by_configs.py do_tiff "+ out_name)
        elif op == "do_tiff":
                from osgeo import ogr, gdal, osr
                out_name = sys.argv[2]
                calc_geotifs_from_h5( out_name )
        end = time.time()
        print(f"tooke {end-start} seconds!")

        exit()
    calc_h5_from_file_config()
