import logging

import requests

import calculator_hv
import utils
import request
from config import get_config


logging.basicConfig(
    #level=logging.INFO,
    level=logging.WARNING,
    format='[%(asctime)s] %(levelname)s: %(message)s',
)


def get_point(input_name, lat, lon, water_session, ernc_session):
    input_ = get_config(f'inputs/{input_name}')
    input_['global']['execution']['position'] = lat, lon
    reference = get_config('constants/input_limits')

    for sub_input_name in input_['inputs']:
        input_[sub_input_name] = get_config(f'inputs/{sub_input_name}')

        logging.info(f'Validating input {sub_input_name} limits')
        year = str(input_[sub_input_name]['project']['year'])
        if year in reference.keys():
            utils.validate_input(reference[year], input_[sub_input_name])
        else:
            logging.warning(f'No reference values for year {year}, skipping validation')

    logging.info('Loading profiles')
    for energy, config in input_['global']['energies'].items():
        if 'profile_template' in config.keys():
            input_['global']['energies'][energy]['profile_config'] = (
                get_config(f'profiles/{config["profile_template"]}'))
            input_['global']['energies'][energy]['profile_config']['position'][0]['lat'] = (
                input_['global']['execution']['position'][0])
            input_['global']['energies'][energy]['profile_config']['position'][0]['lon'] = (
                input_['global']['execution']['position'][1])

    logging.info('Query geoserver')
    if input_['global']['use_local_api']:
        water_api_config = get_config('api/config_api_geo')
    else:
        water_api_config = get_config('api/remote/config_api_geo')
    request_template = get_config('api/geo_request')
    # Computes z coordinate and distance to coast
    request.get_data_water(input_['global'], water_session, water_api_config, request_template)
    # required for model, maybe find another place
    for sub_input_name in input_['inputs']:
        input_[sub_input_name]['project']['position'] = input_['global']['execution']['position']
        input_[sub_input_name]['project']['coord_z'] = input_['global']['execution']['coord_z']
        input_[sub_input_name]['project']['dist_to_coast'] = input_['global']['execution']['dist_to_coast']

    logging.info('Query ernc')
    if input_['global']['use_local_api']:
        ernc_api_config = get_config('api/config_api_ernc')
    else:
        ernc_api_config = get_config('api/remote/config_api_ernc')
    # Computes energy profile per hour
    original_energies_profiles = request.get_data_energies(input_['global'], ernc_session, ernc_api_config)

    list_list = {}
    lcoes_list = {}
    for sub_input_name in input_['inputs']:
        logging.info(f'Processing {sub_input_name}')
        energies_profiles = original_energies_profiles.copy()
        res_calculation_original = None
        list_lcoh = []
        iterations = 12 if input_['global']['execution']['output_with_energies_balance'] else 1
        for iteration in range(iterations):
            logging.info(f'{iteration:>2d}: Processing inputs')
            factor_energies, lcoes = calculator_hv.process_inputs(input_[sub_input_name], energies_profiles, iteration)

            logging.info(f'{iteration:>2d}: Model calculation')
            res_calculation, lcoh = calculator_hv.run_model(input_[sub_input_name], energies_profiles)

            if iteration == 0:
                res_calculation_original = res_calculation.copy()
            list_lcoh.append((*factor_energies, lcoh))

        list_list[sub_input_name] = list_lcoh
        lcoes_list[sub_input_name] = lcoes
        logging.info(f'Saving output for {sub_input_name}')
        #utils.save_output(input_, sub_input_name, original_energies_profiles, res_calculation_original, list_lcoh)
        logging.info('Done')
    return list_list, lcoes_list


if __name__ == "__main__":
    # important for the sessions to be outside
    ernc_session = requests.Session()
    water_session = requests.Session()

    input_results =  get_point('multiple_inputs', -22.28, -68.46, water_session, ernc_session)
