import json
import os.path

import pandas as pd


def validate_input(dict_ref, dict_input, str_trace=''):
    for k, v in dict_ref.items():
        if k in dict_input.keys():
            if isinstance(v, dict):
                validate_input(dict_ref[k], dict_input[k], str_trace=str_trace + f'{k}_')
            elif isinstance(v, list):
                limit_i, limit_s = v
                if (
                        (limit_i is not None and limit_i > dict_input[k]) or
                        (limit_s is not None and limit_s < dict_input[k])):
                    raise ValueError(
                        f'Value input {str_trace}{k} {dict_input[k]} out of bounds for range: [{limit_i}, {limit_s}]'
                    )


def save_output(input_, sub_input_name, energies_profile, res_calculation, list_lcoh, filename=None):
    if filename is None:
        filename = f'{os.path.dirname(__file__)}/output_{sub_input_name}'
    filename = f'{filename}.{input_["global"]["execution"]["output_format"]}'

    df_lcoh = pd.DataFrame()
    if input_['global']['execution']['output_with_energies_balance']:
        df_lcoh = pd.DataFrame(list_lcoh, columns=['eolic %', 'solar %', 'LCOH'])
    if input_['global']['execution']['output_format'] == 'xlsx':
        with pd.ExcelWriter(filename, engine='xlsxwriter') as writer:
            input_[sub_input_name]['project']['position'] = str(input_[sub_input_name]['project']['position'])
            for config in ['project', 'electrolyzer']:
                df_aux = pd.DataFrame(input_[sub_input_name][config], index=[0])
                df_aux.to_excel(writer, sheet_name=f'{config}_config')
            if input_['global']['execution']['output_with_energy_profiles']:
                columns = [col for col in energies_profile.columns if col.startswith('Perfil')]
                energies_profile[columns].to_excel(writer, sheet_name='energies_profiles')
            for res in res_calculation:
                res_calculation[res].to_excel(writer, sheet_name=res[:30])
            if df_lcoh.shape[0] != 0:
                df_lcoh.to_excel(writer, sheet_name='LCOH energy balance', index=False)
    elif input_['global']['execution']['output_format'] == 'json':
        for key in res_calculation:
            res_calculation[key] = res_calculation[key].to_dict()
        if df_lcoh.shape != 0:
            res_calculation['LCOH energy balance'] = df_lcoh.to_dict()
        with open(filename, 'w') as f:
            json.dump(res_calculation, f, ensure_ascii=False)
