import json
from pathlib import Path


def get_config(path):
    json_file = Path(__file__).parent / f'{path}.json'
    if not json_file.exists():
        raise ValueError(f'json file {json_file} does not exist')
    with open(json_file) as config_file:
        return json.load(config_file)
