import json
import logging

import pandas as pd


def get_data_energies(input_global, session, api_config):
    df_profiles = pd.DataFrame()

    for energy in input_global['energies']:
        if 'profile_config' in input_global['energies'][energy].keys():
            res = json.loads(session.post(
                api_config['API_URL'],
                data=json.dumps(input_global['energies'][energy]['profile_config']),
                headers=api_config['headers'],
            ).text)

            if '_ERROR' in res.keys():
                logging.warning(res['_ERROR'])

            df_aux = pd.DataFrame(index=pd.to_datetime(res['time'], unit='s'))
            df_aux[f'Perfil de Energía - {energy}'] = res['data'][0]
            df_profiles = pd.concat([df_profiles, df_aux], axis=1)

    return df_profiles.fillna(0)
        

def get_data_water(input_global, session, api_config, request_template):
    lat, lon = input_global['execution']['position']

    # bbox
    request_template['bbox'] = f'{lon - 0.1},{lat - 0.1},{lon + 0.1},{lat + 0.1}'

    # coast distance
    store = 'h2v'
    current_layer = f'{store}:distCosta3857'
    request_template['layers'] = current_layer
    request_template['query_layers'] = current_layer
    res = json.loads(session.get(api_config['API_URL'].format(store=store), params=request_template).text)
    dist_to_coast = res['features'][0]['properties']['GRAY_INDEX'] / 1000

    # z coord
    store = 'esolar'
    current_layer = f'{store}:dem3857'
    request_template['layers'] = current_layer
    request_template['query_layers'] = current_layer
    res = json.loads(session.get(api_config['API_URL'].format(store=store), params=request_template).text)
    coord_z = res['features'][0]['properties']['GRAY_INDEX']
    
    input_global['execution']['dist_to_coast'] = max(dist_to_coast, 0)
    input_global['execution']['coord_z'] = coord_z
