# encoding: utf-8


from datetime import datetime
import pytz

import json
import pandas as pd
import requests
import os
import sys
orig_path = os.getcwd()
sys.path.append("/home/usr_uchile/opt/api/pydef")
os.chdir("/home/usr_uchile/opt/api/pydef")

import json
import traceback
import importlib

import config
import ernc

print( "CREATING EXTRACTOR OBJECT" )
e = ernc.extractor( prepare=True )
print( "DONE" )


print("SUCESSSSSS")

config = json.load(open("config/config_api_ernc.json"))
API_ERNC_URL = config["API_URL"]
token   = config['token']
headers_ernc = {"Content-Type": "application/json"}
headers_ernc["Authorization"] = "Token {}".format(token)

config = json.load(open("config/config_api_geo.json"))
API_GEO_URL = config["API_URL"]
#token   = config['token']
#headers_geo = {"Content-Type": "application/json"}
#headers_geo["Authorization"] = "Token {}".format(token)

def transform_to_timestamps(list_dt, format="unix"):

    list_new_dt = []
    if format=="unix":
        for dt in list_dt:
            list_new_dt.append(datetime.fromtimestamp(dt, tz=pytz.utc).strftime("%Y-%m-%d %H:%M:%S"))
    return list_new_dt


def api_req(text_req):
    #print(text_req, type(text_req))
    #res = json.loads(requests.post(API_ERNC_URL, data = text_req, headers=headers_ernc).text)
    w = ernc.web( text_req, extractor_instance = e)
    data = w.run()

    #print(res.keys())
    #print(len(res["data"]))
    #print(res['time'])
    if "_ERROR" in res.keys():
        print(res["_ERROR"])
    return res

def get_data_energies(inputs):

    """
    input: {
        "energies":{
            "energies_config":"{
                "<energy>":{
                    "profile_config":
                            }
            }
        }
    }    
    """

    df_profiles = pd.DataFrame(pd.np.empty((8760,1)))
    for energy in inputs["energies"]["energies_config"]:
        if "profile_config" in inputs["energies"]["energies_config"][energy].keys():
            res = api_req(inputs["energies"]["energies_config"][energy]["profile_config"])
            df_aux = pd.DataFrame(index=transform_to_timestamps(res["time"]))
            df_aux[u"Perfil de Energía - "+energy] = res["data"][0]
            print(df_aux.shape)
            print(df_profiles.shape)
            df_profiles.index=df_aux.index
            df_profiles = pd.concat([df_profiles, df_aux], axis=1)
    #print(df_profiles.shape)

    inputs["energies"]["energies_profile"] = df_profiles
    
    #print(df_profiles.head(10))

    return inputs
        

def get_data_water(inputs):


    lat = inputs["project_config"]["position"]["lat"]
    lon = inputs["project_config"]["position"]["lon"]

    filename_template = "config/templates_geo/geo_request.json"
    dict_geo = json.load(open(filename_template))

    # bbox
    dict_geo["bbox"] = str(lon - 0.1) + ',' + str(lat - 0.1) + ',' + str(lon + 0.1) + ',' + str(lat + 0.1)

    # coast distance
    store = "h2v"
    currentLayer = store+":distCosta3857"
    dict_geo["layers"] = currentLayer
    dict_geo["query_layers"] = currentLayer
    res = json.loads(requests.get(API_GEO_URL.format(store=store), params=dict_geo, verify=False).text)
    #print(res)
    dist_to_coast = res["features"][0]["properties"]["GRAY_INDEX"]/1000

    # coast distance
    store = "esolar"
    currentLayer = store+":dem3857"
    dict_geo["layers"] = currentLayer
    dict_geo["query_layers"] = currentLayer
    #print(dict_geo)
    res = json.loads(requests.get(API_GEO_URL.format(store=store), params=dict_geo, verify=False).text)
    #print(res.text)
    coord_z = res["features"][0]["properties"]["GRAY_INDEX"]
    
    #coord_z = 100 #km
    #dist_to_coast = 1 #km

    inputs["project_config"]["coord_z"] = coord_z
    inputs["project_config"]["dist_to_coast"] = dist_to_coast
    #print(inputs["project_config"])
    return inputs
    
