import os
import copy
import json
import pandas as pd
import h5py
import os
import numpy as np
import sys

#import direct_request 

filename = "input_2022.json"



def get_mix_for_latlon(lat, lon, direct=False):
    execution_inputs_formatted = processing.format_inputs(filename, input_type="repeater")
    execution_inputs_formatted["output_format"] = "json"
    execution_inputs_formatted["points"] = [[lat, lon]]
        
    for p_i in range(len(execution_inputs_formatted["points"])):

        #print(f"[{p_i}] FORMATTING FOR REPEATER INPUTS...")
        inputs_formatted = processing.format_inputs(filename, points=execution_inputs_formatted["points"][p_i])
            
        inputs_formatted = request.get_data_water(inputs_formatted)
        if inputs_formatted["project_config"]["dist_to_coast"] < 0: return
        inputs_formatted = request.get_data_energies(inputs_formatted)
            
        list_lcoh = []
        for b_i in range(execution_inputs_formatted["b_iterations"]):
            #print(f"[{p_i}][{b_i}] PROCESSING ALL INPUTS...")
            input_calculator, factor_energies = processing.process_inputs_hv_calculator(copy.deepcopy(inputs_formatted), iteration=b_i)
                
            #print(f"[{p_i}][{b_i}] MODEL CALCULATION...")
            res_calculation, lcoh = calculator_hv.run_model(input_calculator.copy()) #res_general, cost_results, lcoh, lcoh_grouped, generation_profile 
            if b_i == 0:
                res_calculation_original = res_calculation.copy()
            list_lcoh.append([factor_energies[0], factor_energies[1], lcoh])

        lcoh = list_lcoh[0][2]
        mixes = list_lcoh[1:]
        mixes.sort(key=lambda x: x[2])
        best_mix = mixes[0]

        return lcoh, best_mix

def calc_h5_from_file_config(filename=filename, out_name="test", small=False, direct=False):
    mask = h5py.File(os.path.join("data","h5", "mask_v2.h5"), 'r')
    try:
        ofile = h5py.File(os.path.join("data","h5", out_name + ".h5"), 'a')
        ofile["mask"]
        is_before = True
        print("\n\n LOADED FROM BEFORE!!! \n\n")
    except:
        ofile.close()
        is_before = False
        ofile = h5py.File(os.path.join("data","h5", out_name + ".h5"), 'w')
        ofile.create_dataset("mask", mask["mask"].shape, 'i2')
        ofile["mask"][:] = -1
        ofile.create_dataset("lat",  mask["lat"].shape, 'f8')
        ofile.create_dataset("lon",  mask["lon"].shape, 'f8')
    
        ofile.create_dataset("lcoh",        ofile["mask"].shape, 'f8')
        ofile.create_dataset("lcoh_best",   ofile["mask"].shape, 'f8')
        ofile.create_dataset("frac_1",      ofile["mask"].shape, 'u1')
        ofile.create_dataset("frac_2",      ofile["mask"].shape, 'u1')
    
        ofile["lat"][:] = mask["lat"][:]
        ofile["lon"][:] = mask["lon"][:]
    # mask["mask"][lon, lat]
    n_lon = mask["lon"].shape[0]
    n_lat = mask["lat"].shape[0]
    if small:
        start_lat = int(49 * n_lat / 100)
        end_lat = int(51 * n_lat / 100)
    else:
        start_lat = 0
        end_lat = n_lat
    advance_perc = 0
    lcoh = 0
    for i_lon in range(n_lon):
        perc = round((i_lon/n_lon) * 100)
        if ( perc >= advance_perc):
            print("Advanced: ", perc, i_lon, n_lon, lcoh)
            advance_perc += 1
            ofile.close()
            ofile = h5py.File(os.path.join("data","h5", out_name + ".h5"), 'a')
            
            

        for i_lat in range(start_lat, end_lat):
            #if is_before and (ofile["mask"][i_lon, i_lat] == 1 or ofile["mask"][i_lon, i_lat] == 0):
            if is_before and ofile["mask"][i_lon, i_lat] == 1 : #or ofile["mask"][i_lon, i_lat] == 0):
                continue
            ofile["mask"][i_lon, i_lat] = 0
            if mask["mask"][i_lon, i_lat] == 1:
                lat = mask["lat"][i_lat]
                lon = mask["lon"][i_lon]
                try:
                    lcoh, best_mix = get_mix_for_latlon(lat, lon, direct)
                    ofile["mask"][i_lon, i_lat] = 1

                    ofile["lcoh"][i_lon, i_lat] = lcoh
                    ofile["lcoh_best"][i_lon, i_lat] = best_mix[2]
                    ofile["frac_1"][i_lon, i_lat] = best_mix[0]
                    ofile["frac_2"][i_lon, i_lat] = best_mix[1]
                    print(lcoh, " advanced ", perc)
                except:
                    #print(f"Error in lat, lon ({lat}, {lon}) in calck LCOH")
                    print("error in ", lat, lon, " advanced ", perc)

    
    ofile.close()

    return

def to_geotiff(fh5, filename,  var_name):
	fo  = h5py.File( fh5, 'r' )

   
	filename = filename + "_" + var_name + ".tif"
	
	lon0 = fo["lon"][0]
	lat0 = fo["lat"][0]

	dlon = 0.01
	dlat = 0.01

	rasterOrigin=(lon0,lat0)
	pixelWidth  = dlon
	pixelHeight = dlat

	# Factor de planta
	array       = np.squeeze(fo[var_name][:,:])
	array       = np.transpose(array)
	array2raster(filename,rasterOrigin,pixelWidth,pixelHeight,array)
	publish_geotiff( filename )
    
	return

def array2raster(newRasterfn,rasterOrigin,pixelWidth,pixelHeight,array):

    cols = array.shape[1]
    rows = array.shape[0]
    originX = rasterOrigin[0]
    originY = rasterOrigin[1]

    driver = gdal.GetDriverByName('GTiff')
    outRaster = driver.Create(newRasterfn, cols, rows, 1, gdal.GDT_Float32)
    outRaster.SetGeoTransform((originX, pixelWidth, 0, originY, 0, pixelHeight))
    outband = outRaster.GetRasterBand(1)
    outband.WriteArray(array)
    outRasterSRS = osr.SpatialReference()
    outRasterSRS.ImportFromEPSG(4326)
    outRaster.SetProjection(outRasterSRS.ExportToWkt())
    outband.FlushCache()
    return

def publish_geotiff(work_file, usemask=True, doutm=True):

	path, vname = os.path.split(work_file)

	geogpath   = '../geog/'
	fname = work_file
	fname_ll   = '../geog/geotiff/latlon/%s_ll.tif' % (vname, )
	fname_utm  = '../geog/geotiff/utm/%s_utm.tif' % (vname,) 

	if usemask:
		comm = 'gdalwarp -overwrite -srcnodata -9999 -dstnodata -9999 -crop_to_cutline -cutline %s/masks/CL_Buffer_15km_DDw84.shp %s %s' % (geogpath, fname, fname_ll)
		print(comm)
		os.system(comm);

		if doutm:
			comm = "gdalwarp -overwrite -srcnodata -9999 -dstnodata -9999 -s_srs EPSG:4326 -t_srs '+proj=utm +zone=19 +datum=WGS84 +south' -tr 1000 1000 -r bilinear -crop_to_cutline -cutline %s/masks/CL_Buffer_15km_DDw84.shp %s %s" % (geogpath, fname, fname_utm)
			print(comm)
			os.system(comm);
	else:
		comm = 'gdalwarp -overwrite -srcnodata -9999 -dstnodata -9999 %s %s' % (fname, fname_ll)
		print(comm)
		os.system(comm);

		if doutm:
			comm = "gdalwarp -overwrite -srcnodata -9999 -dstnodata -9999 -s_srs EPSG:4326 -t_srs '+proj=utm +zone=19 +datum=WGS84 +south' -tr 1000 1000 -r bilinear %s %s" % (fname, fname_utm)
			print(comm)
			os.system(comm);


def calc_geotifs_from_h5( out_name ):
    to_geotiff(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "mask")
    to_geotiff(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "lcoh")
    to_geotiff(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "lcoh_best")
    to_geotiff(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "frac_1")
    to_geotiff(os.path.join("data","h5", out_name + ".h5"), os.path.join("data","tif", out_name), "frac_2")
    

if __name__ == "__main__":
    if len(sys.argv)>1:
        op = sys.argv[1]
        if op == "do_h5":
                import calculator_hv
                import processing
                import request 

                config_name = sys.argv[2]
                out_name = sys.argv[3]
                is_small = 'small' in out_name
                print("DOING ", config_name, out_name)
                calc_h5_from_file_config(filename=config_name+".json", out_name=out_name, small=is_small, direct=False)
                print(" now do with python2 environemtn ' python get_map_by_configs.py do_tiff "+ out_name)
        elif op == "do_tiff":
                from osgeo import ogr, gdal, osr
                out_name = sys.argv[2]
                calc_geotifs_from_h5( out_name )

        exit()
    calc_h5_from_file_config()
