import argparse
import copy
import json
import pandas as pd

import calculator_hv
import processing
import request 


def main():

    print("READING INPUTS...")
    arg_parser = argparse.ArgumentParser()
    arg_parser.add_argument('--filename', '-f', default='input.json')
    #arg_parser.add_argument('--repeater_filename', '-rf', default='repeater_input.json')
    #arg_parser.add_argument('--output_format', '-o', default='xlsx')
    #arg_parser.add_argument('--output_energy_profiles', '-e', default=0)
    #arg_parser.add_argument('--output_energies_balance', '-eb', default=0)
    args = arg_parser.parse_args()

    filename = args.filename
    #repeater_filename = args.repeater_filename
    #output_format = args.output_format
    #output_energy_profiles = int(args.output_energy_profiles)
    #output_energies_balance = int(args.output_energies_balance)
    
    print("FORMATTING REPEATER INPUTS...")
    execution_inputs_formatted = processing.format_inputs(filename, input_type="repeater")
    
    for p_i in range(len(execution_inputs_formatted["points"])):

        print(f"[{p_i}] FORMATTING FOR REPEATER INPUTS...")
        inputs_formatted = processing.format_inputs(filename, points=execution_inputs_formatted["points"][p_i])
        
        print(f"[{p_i}] REQUESTING DATA APIs...")
        inputs_formatted = request.get_data_energies(inputs_formatted)
        inputs_formatted = request.get_data_water(inputs_formatted)
        
        list_lcoh = []
        for b_i in range(execution_inputs_formatted["b_iterations"]):
            print(f"[{p_i}][{b_i}] PROCESSING ALL INPUTS...")
            input_calculator, factor_energies = processing.process_inputs_hv_calculator(copy.deepcopy(inputs_formatted), iteration=b_i)
            
            print(f"[{p_i}][{b_i}] MODEL CALCULATION...")
            res_calculation, lcoh = calculator_hv.run_model(input_calculator.copy()) #res_general, cost_results, lcoh, lcoh_grouped, generation_profile 
            if b_i == 0:
                res_calculation_original = res_calculation.copy()
            list_lcoh.append([factor_energies[0], factor_energies[1], lcoh])

        print(f"[{p_i}] SAVING OUTPUT...")
        processing.save_output(inputs_formatted, execution_inputs_formatted, res_calculation_original, list_lcoh, filename=f"/tmp/lcoh_model_{p_i}")


if __name__ == "__main__":
    main()
